#version 430 core
layout (location = 0) out vec4 screenTexture;

in vec2 TexCoords;

layout (binding = 0) uniform sampler2D gAlbedoSpec;
layout (binding = 1) uniform sampler2D gViewPos;

uniform int isFxaaOn;
uniform int SCR_HEIGHT;
uniform int SCR_WIDTH;


void main()
{       
	
	vec3 Diffuse = texture(gAlbedoSpec, TexCoords).rgb;

	float fragDepth = texture(gViewPos, TexCoords).z;

	vec2 texCoordOffset = vec2(1.0f/SCR_WIDTH, 1.0f/SCR_HEIGHT); //this needs later fixing to take in screen dimensions


	if(fragDepth > -600){
	
			if(isFxaaOn == 1)
		{
	
		vec3 DiffuseTL = texture(gAlbedoSpec, (TexCoords + (vec2(-1.0, -1.0) * texCoordOffset))).rgb;
		vec3 DiffuseTR = texture(gAlbedoSpec, (TexCoords + (vec2(1.0, -1.0) * texCoordOffset))).rgb;
		vec3 DiffuseBR = texture(gAlbedoSpec, (TexCoords + (vec2(1.0, 1.0) * texCoordOffset))).rgb;
		vec3 DiffuseBL = texture(gAlbedoSpec, (TexCoords + (vec2(-1.0, 1.0) * texCoordOffset))).rgb;
	 
		//fxaa begins here

		vec3 luma = vec3(0.299, 0.587, 0.114); //luminocity vector, look this up later

			float lumaM = dot(luma, Diffuse);
			float lumaTL = dot(luma, DiffuseTL);
			float lumaTR = dot(luma, DiffuseTR);
			float lumaBL = dot(luma, DiffuseBL);
			float lumaBR = dot(luma, DiffuseBR);

			vec2 dir;
			dir.x = -((lumaTL + lumaTR) - (lumaBL + lumaBR)); 
			dir.y = ((lumaTL + lumaBL) - (lumaTR + lumaBR));

			float R_fxaaReduceMul = 1.0f/8.0f; // these need to be uniforms
			float R_fxaaReduceMin = 1.0f/128.0f;
			float R_fxaaSpanMax = 8.0;

			float dirReduce = max((lumaTL + lumaTR + lumaBL + lumaBR) * (R_fxaaReduceMul * 0.25), R_fxaaReduceMin);
			float inverseDirAdjustment = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);

			dir = min(vec2(R_fxaaSpanMax, R_fxaaSpanMax), 
			max(vec2(-R_fxaaSpanMax, -R_fxaaSpanMax), dir * inverseDirAdjustment)) * texCoordOffset;

		vec3 result1 = (1.0/2.0) * (
			texture2D(gAlbedoSpec, TexCoords + (dir * vec2(1.0/3.0 - 0.5))).xyz +
			texture2D(gAlbedoSpec, TexCoords + (dir * vec2(2.0/3.0 - 0.5))).xyz
			);

		vec3 result2 = result1 * (1.0/2.0) + (1.0/4.0) * (
			texture2D(gAlbedoSpec, TexCoords + (dir * vec2(0.0/3.0 - 0.5))).xyz +
			texture2D(gAlbedoSpec, TexCoords + (dir * vec2(3.0/3.0 - 0.5))).xyz);

		float lumaMin = min(lumaM, min(min(lumaTL, lumaTR), min(lumaBL, lumaBR)));
		float lumaMax = max(lumaM, max(max(lumaTL, lumaTR), max(lumaBL, lumaBR)));
		float lumaResult2 = dot(luma, result2);

		if(lumaResult2 < lumaMin || lumaResult2 > lumaMax)
			Diffuse = result1;
		else
			Diffuse = result2;
		

	  screenTexture = vec4(Diffuse, 0.0);

	  }

	  else
	  {
	  screenTexture = vec4(Diffuse, 0.0);
	  }
	
}else{
	
		if(fragDepth != -10000){

		vec3 DiffuseTL = texture(gAlbedoSpec, (TexCoords + (vec2(-1.0, -1.0) * texCoordOffset))).rgb;
		vec3 DiffuseTR = texture(gAlbedoSpec, (TexCoords + (vec2(1.0, -1.0) * texCoordOffset))).rgb;
		vec3 DiffuseBR = texture(gAlbedoSpec, (TexCoords + (vec2(1.0, 1.0) * texCoordOffset))).rgb;
		vec3 DiffuseBL = texture(gAlbedoSpec, (TexCoords + (vec2(-1.0, 1.0) * texCoordOffset))).rgb;


		float blendWeight = 400.0 / abs(fragDepth);

		blendWeight = clamp(blendWeight, 0.5, 1.0);

		float quarterBlendWeight = (1.0 - blendWeight)/4.0;

		Diffuse *= blendWeight;
		Diffuse += quarterBlendWeight * DiffuseTL;
		Diffuse += quarterBlendWeight * DiffuseTR;
		Diffuse += quarterBlendWeight * DiffuseBR;
		Diffuse += quarterBlendWeight * DiffuseBL;


		  screenTexture = vec4(Diffuse, 0.0);
		}
		else{
		
			screenTexture = vec4(Diffuse, 0.0);

		}


	}


  

}